<?php

/**
 * Coupon section of the plugin
 *
 * @link           
 *
 * @package  Wt_Import_Export_For_Woo 
 */
if (!defined('ABSPATH')) {
    exit;
}

if(!class_exists('Wt_Import_Export_For_Woo_Basic_Coupon')){
class Wt_Import_Export_For_Woo_Basic_Coupon {

    public $module_id = '';
    public static $module_id_static = '';
    public $module_base = 'coupon';
    public $module_name = 'Coupon Import Export for WooCommerce';
    public $min_base_version= '1.0.0'; /* Minimum `Import export plugin` required to run this add on plugin */

    private $importer = null;
    private $exporter = null;
    private $all_meta_keys = array();
    private $found_meta = array();
    private $found_hidden_meta = array();
	private $selected_column_names = null;

    public function __construct()
    {
        /**
        *   Checking the minimum required version of `Import export plugin` plugin available
        */
        if(!Wt_Import_Export_For_Woo_Basic_Common_Helper::check_base_version($this->module_base, $this->module_name, $this->min_base_version))
        {
            return;
        }
        if(!function_exists('is_plugin_active'))
        {
            include_once(ABSPATH.'wp-admin/includes/plugin.php');
        }
        if(!is_plugin_active('woocommerce/woocommerce.php'))
        {
            return;
        }

        $this->module_id = Wt_Import_Export_For_Woo_basic::get_module_id($this->module_base);
        self::$module_id_static = $this->module_id;
       
        add_filter('wt_iew_exporter_post_types_basic', array($this, 'wt_iew_exporter_post_types_basic'), 10, 1);
        add_filter('wt_iew_importer_post_types_basic', array($this, 'wt_iew_exporter_post_types_basic'), 10, 1);
        
        add_filter('wt_iew_exporter_alter_mapping_fields_basic', array($this, 'exporter_alter_mapping_fields'), 10, 3);        
        add_filter('wt_iew_importer_alter_mapping_fields_basic', array($this, 'get_importer_post_columns'), 10, 3);  
        
		add_filter('wt_iew_exporter_alter_filter_fields_basic', array($this, 'exporter_alter_filter_fields'), 10, 3);
		
        add_filter('wt_iew_importer_alter_advanced_fields_basic', array($this, 'importer_alter_advanced_fields'), 10, 3);

        add_filter('wt_iew_exporter_alter_meta_mapping_fields_basic', array($this, 'exporter_alter_meta_mapping_fields'), 10, 3);
        add_filter('wt_iew_importer_alter_meta_mapping_fields_basic', array($this, 'importer_alter_meta_mapping_fields'), 10, 3);

        add_filter('wt_iew_exporter_alter_mapping_enabled_fields_basic', array($this, 'exporter_alter_mapping_enabled_fields'), 10, 3);
        add_filter('wt_iew_importer_alter_mapping_enabled_fields_basic', array($this, 'exporter_alter_mapping_enabled_fields'), 10, 3);

        add_filter('wt_iew_exporter_do_export_basic', array($this, 'exporter_do_export'), 10, 7);
        add_filter('wt_iew_importer_do_import_basic', array($this, 'importer_do_import'), 10, 8);

        add_filter('wt_iew_importer_steps_basic', array($this, 'importer_steps'), 10, 2);
		
		add_action('admin_footer-edit.php', array($this, 'add_coupons_bulk_actions'));
        add_action('load-edit.php', array($this, 'process_coupons_bulk_actions'));
    }

	
	public function add_coupons_bulk_actions() {
        global $post_type, $post_status;

        if ( 'shop_coupon' === $post_type && 'trash' !== $post_status && !is_plugin_active( 'wt-import-export-for-woo/wt-import-export-for-woo.php' )) {
            ?>
            <script type="text/javascript">
                jQuery(document).ready(function ($) {
                    var $downloadToCSV = $('<option>').val('wt_ier_download_coupons').text('<?php esc_html_e('Export to CSV', 'order-import-export-for-woocommerce') ?>');
                    $('select[name^="action"]').append($downloadToCSV);
                });
            </script>
            <?php
        }
    }

    public function process_coupons_bulk_actions() {
        global $typenow;
        if ($typenow == 'shop_coupon') {
            // get the action list
            $wp_list_table = _get_list_table('WP_Posts_List_Table');
            $action = $wp_list_table->current_action();
            if (!in_array($action, array('wt_ier_download_coupons'))) {
                return;
            }
            check_admin_referer('bulk-posts');

            if (isset($_REQUEST['post'])) {
                $coupon_ids = array_map('absint', $_REQUEST['post']);
            }
            if (empty($coupon_ids)) {
                return;
            }
            // phpcs:ignore Squiz.PHP.DiscouragedFunctions.Discouraged
            @set_time_limit(0);

            if ($action == 'wt_ier_download_coupons') {
                include_once( 'export/class-wt-cpnimpexpcsv-basic-exporter.php' );
                Wt_Import_Export_For_Woo_Basic_Coupon_Bulk_Export::do_export('shop_coupon', $coupon_ids);
            }
        }
    }
    /**
    *   Altering advanced step description
    */
    public function importer_steps($steps, $base)
    {
        if($this->module_base==$base)
        {
            $steps['advanced']['description']=__('Use advanced options from below to decide updates to existing coupons, batch import count. You can also save the template file for future imports.', 'order-import-export-for-woocommerce');
        }
        return $steps;
    }
    
    public function importer_do_import($import_data, $base, $step, $form_data, $selected_template_data, $method_import, $batch_offset, $is_last_batch) {        
        if ($this->module_base != $base) {
            return $import_data;
        }
        
        if(0 == $batch_offset){                        
            $memory = size_format(wt_let_to_num_basic(ini_get('memory_limit')));
            $wp_memory = size_format(wt_let_to_num_basic(WP_MEMORY_LIMIT));                      
            Wt_Import_Export_For_Woo_Basic_Logwriter::write_log($this->module_base, 'import', '---[ New import started at '.gmdate('Y-m-d H:i:s').' ] PHP Memory: ' . $memory . ', WP Memory: ' . $wp_memory);
        }
        
        include plugin_dir_path(__FILE__) . 'import/import.php';
        $import = new Wt_Import_Export_For_Woo_Basic_Coupon_Import($this);
        
        $response = $import->prepare_data_to_import($import_data,$form_data,$batch_offset,$is_last_batch);
        
        if($is_last_batch){
            Wt_Import_Export_For_Woo_Basic_Logwriter::write_log($this->module_base, 'import', '---[ Import ended at '.gmdate('Y-m-d H:i:s').']---');
        }
                
        return $response;
    }
    
    
    public function exporter_do_export($export_data, $base, $step, $form_data, $selected_template_data, $method_export, $batch_offset) {
        if ($this->module_base != $base) {
            return $export_data;
        }
                
        switch ($method_export) {
            case 'quick':
                $this->set_export_columns_for_quick_export($form_data);  
                break;

            case 'template':            
            case 'new':
                $this->set_selected_column_names($form_data);
                break;
            
            default:
                break;
        }
        
        include plugin_dir_path(__FILE__) . 'export/export.php';
        $export = new Wt_Import_Export_For_Woo_Basic_Coupon_Export($this);

        $header_row = $export->prepare_header();

        $data_row = $export->prepare_data_to_export($form_data, $batch_offset);
		
        $export_data = array(
            'head_data' => $header_row,
            'body_data' => $data_row['data'],
            'total' => $data_row['total'],
        );
        
        return $export_data;
    }
    
    /*
     * Setting default export columns for quick export
     */

    public function set_export_columns_for_quick_export($form_data) {

        $post_columns = self::get_coupon_post_columns();

        $this->selected_column_names = array_combine(array_keys($post_columns), array_keys($post_columns));

        if (isset($form_data['method_export_form_data']['mapping_enabled_fields']) && !empty($form_data['method_export_form_data']['mapping_enabled_fields'])) {
            foreach ($form_data['method_export_form_data']['mapping_enabled_fields'] as $value) {
                $additional_quick_export_fields[$value] = array('fields' => array());
            }

            $export_additional_columns = $this->exporter_alter_meta_mapping_fields($additional_quick_export_fields, $this->module_base, array());
            foreach ($export_additional_columns as $value) {
                $this->selected_column_names = array_merge($this->selected_column_names, $value['fields']);
            }
        }
    }

    
    /**
     * Adding current post type to export list
     *
     */
    public function wt_iew_exporter_post_types_basic($arr) {
        $arr['coupon'] = __('Coupon', 'order-import-export-for-woocommerce');
        return $arr;
    }

    public static function get_coupon_types() {
        $coupon_types   = wc_get_coupon_types();
        return apply_filters('wt_iew_export_coupon_types',  $coupon_types);
        
    }

    public static function get_coupon_statuses() {
        $statuses = array('publish', 'private', 'draft', 'pending', 'future'); 
        return apply_filters('wt_iew_export_coupon_statuses', array_combine($statuses, $statuses));
    }

    public static function get_coupon_sort_columns() {                
        $sort_columns = array('ID', 'post_parent', 'post_title', 'post_date', 'post_modified', 'post_author', 'menu_order', 'comment_count');
        return apply_filters('wt_iew_export_coupon_sort_columns', array_combine($sort_columns, $sort_columns));
    }

    public static function get_coupon_post_columns() {
        return include plugin_dir_path(__FILE__) . 'data/data-coupon-post-columns.php';
    }
    
    public function get_importer_post_columns($fields, $base, $step_page_form_data) {
        if ($base != $this->module_base) {
            return $fields;
        }
        $colunm = include plugin_dir_path(__FILE__) . 'data/data/data-wf-reserved-fields-pair.php';
//        $colunm = array_map(function($vl){ return array('title'=>$vl, 'description'=>$vl); }, $arr); 
        return $colunm;
    }
    
    public function exporter_alter_mapping_enabled_fields($mapping_enabled_fields, $base, $form_data_mapping_enabled_fields) {
        if ($base == $this->module_base) {
            $mapping_enabled_fields = array();

            $mapping_enabled_fields['hidden_meta'] = array(__('Hidden meta', 'order-import-export-for-woocommerce'), 0);

            if ( ! function_exists( 'is_plugin_active' ) ) {
                include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
            }

            // Check if premium plugin is active.
            if ( ! is_plugin_active( 'wt-import-export-for-woo-order/wt-import-export-for-woo-order.php' ) ) {
                if ( $this->wt_get_found_hidden_meta() ) {
                    $mapping_enabled_fields['hidden_meta']['banner_html'] = $this->get_upgrade_banner_html();
                }
            }
        }
        return $mapping_enabled_fields;
    }

    /**
     * Get upgrade banner HTML for premium features
     */
    public function get_upgrade_banner_html() {
        return '<div id="product-type-notice" style="margin-top: 10px; display: block; width: 850px; height: auto; top: 210px; left: 117px;">
    <div class="notice notice-warning" style="width: 92.5%; max-width: 810px; margin-left: 0px; display: inline-flex; padding: 16px 18px 16px 26px; justify-content: flex-end; align-items: center; border-radius: 8px; border: 1px solid #F5F9FF; background-color: #F5F9FF; box-sizing: border-box;">
        <div style="display: flex; flex: 1 1 0; flex-direction: column; justify-content: flex-start; align-items: flex-start; width: 100%;">
            <!-- Title -->
            <div style="padding-bottom: 10px; align-self: stretch; color: #2A3646; font-size: 14px; font-family: Inter; font-weight: 600; line-height: 16px; word-wrap: break-word;">
                ' . __('Upgrade to premium 💎', 'order-import-export-for-woocommerce') . '
            </div>

            <!-- Description -->
            <div style="width: 100%; max-width: 679px; padding-bottom: 10px;">
                <span style="color: #2A3646; font-size: 13px; font-family: Inter; font-weight: 400; ">
                        ' . __('We\'ve detected hidden WooCommerce metadata & custom coupon fields in your store. Unlock full access to export them seamlessly.', 'order-import-export-for-woocommerce') . '
                    </span>
                </div>

            <!-- Button -->
                <a href="//www.webtoffee.com/product/order-import-export-plugin-for-woocommerce/?utm_source=free_plugin&utm_medium=export_hidden_meta_tab&utm_campaign=Order_Import_Export" target="_blank" style="
                    width: auto;
                    height: 18px;
                font-family:  \'Inter\', sans-serif;
                    font-weight: 600;
                    font-size: 12px;
                    line-height: 100%;
                    color: #2B28E9;
                    display: inline-flex;
                    align-items: center;
                    justify-content: center;
                    border-radius: 4px;
                    gap: 5px;
                    text-decoration: none;
                margin-top: 0px;
                ">
                    ' . __('Upgrade now', 'order-import-export-for-woocommerce') . ' <span style="font-size: 14px;">→</span>
                </a>
            </div>
        </div>
    </div>
';
    }

    
    public function exporter_alter_meta_mapping_fields($fields, $base, $step_page_form_data) {
        if ($base != $this->module_base) {
            return $fields;
        }

        foreach ($fields as $key => $value) {
            switch ($key) {              
                default:
                    break;
            }
        }

        return $fields;
    }
    
    public function importer_alter_meta_mapping_fields($fields, $base, $step_page_form_data) {
        if ($base != $this->module_base) {
            return $fields;
        }
        $fields=$this->exporter_alter_meta_mapping_fields($fields, $base, $step_page_form_data);
        $out=array();
        foreach ($fields as $key => $value) 
        {
            $value['fields']=array_map(function($vl){ return array('title'=>$vl, 'description'=>$vl); }, $value['fields']);
            $out[$key]=$value;
        }
        return $out;
    }
    
    public function wt_get_found_meta() {

        if (!empty($this->found_meta)) {
            return $this->found_meta;
        }

        // Loop products and load meta data
        $found_meta = array();
        // Some of the values may not be usable (e.g. arrays of arrays) but the worse
        // that can happen is we get an empty column.

        $all_meta_keys = $this->wt_get_all_meta_keys();


        $csv_columns = self::get_coupon_post_columns();


        foreach ($all_meta_keys as $meta) {

            if (!$meta || (substr((string) $meta, 0, 1) == '_') || in_array($meta, array_keys($csv_columns)) || in_array('meta:' . $meta, array_keys($csv_columns)))
                continue;

            $found_meta[] = $meta;
        }
        
        $found_meta = array_diff($found_meta, array_keys($csv_columns));
        $this->found_meta = $found_meta;
        return $this->found_meta;
    }

    public function wt_get_found_hidden_meta() {
        global $wpdb;
    
        // phpcs:disable WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Its necessary to use direct database query.
        $result = $wpdb->get_var("
            SELECT 1
            FROM {$wpdb->postmeta} pm
            JOIN {$wpdb->posts} p ON p.ID = pm.post_id
            WHERE pm.meta_key LIKE '_%'
            AND p.post_type = 'shop_coupon'
            LIMIT 1
        ");
        // phpcs:enable
        return $result !== null;
    }


    public function wt_get_all_meta_keys() {

        if (!empty($this->all_meta_keys)) {
            return $this->all_meta_keys;
        }

        $all_meta_keys = self::get_all_metakeys('shop_coupon');

        $this->all_meta_keys = $all_meta_keys;
        return $this->all_meta_keys;
    }

        
    public static function get_all_metakeys($post_type = 'shop_coupon') {
        global $wpdb;

        // phpcs:disable WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Its necessary to use direct database query.
        $meta = $wpdb->get_col($wpdb->prepare(
                        "SELECT DISTINCT pm.meta_key
            FROM {$wpdb->postmeta} AS pm
            LEFT JOIN {$wpdb->posts} AS p ON p.ID = pm.post_id
            WHERE p.post_type = %s
            AND p.post_status IN ( 'publish', 'pending', 'private', 'draft' )", $post_type
                ));
        // phpcs:enable
        sort($meta);

        return $meta;
    }
    
    
    public function set_selected_column_names($full_form_data) {        
        if (is_null($this->selected_column_names)) {
            if (isset($full_form_data['mapping_form_data']['mapping_selected_fields']) && !empty($full_form_data['mapping_form_data']['mapping_selected_fields'])) {
                $this->selected_column_names = $full_form_data['mapping_form_data']['mapping_selected_fields'];
            }
            if (isset($full_form_data['meta_step_form_data']['mapping_selected_fields']) && !empty($full_form_data['meta_step_form_data']['mapping_selected_fields'])) {
                $export_additional_columns = $full_form_data['meta_step_form_data']['mapping_selected_fields'];
                foreach ($export_additional_columns as $value) {
                    $this->selected_column_names = array_merge($this->selected_column_names, $value);
                }
            }
        }

        return $full_form_data;
    }
    
    public function get_selected_column_names() {
            
        return $this->selected_column_names;
    }    

    public function exporter_alter_mapping_fields($fields, $base, $mapping_form_data) {
        if ($base == $this->module_base) {
            $fields = self::get_coupon_post_columns();
        }
        return $fields;
    }
    
    public function importer_alter_advanced_fields($fields, $base, $advanced_form_data) {
        if ($this->module_base != $base) {
            return $fields;
        }
        $out = array();         
        $out['found_action_merge'] = array(
            'label' => __("If the coupon exists in the store", 'order-import-export-for-woocommerce'),
            'type' => 'radio',
            'radio_fields' => array(
                'skip' => __('Skip', 'order-import-export-for-woocommerce'),
                'update' => __('Update', 'order-import-export-for-woocommerce'),                
            ),
            'value' => 'skip',
            'field_name' => 'found_action',
            'help_text_conditional'=>array(
                array(
                    'help_text'=> __('This option will not update the existing coupons and keeps the coupons as is.', 'order-import-export-for-woocommerce'),
                    'condition'=>array(
                        array('field'=>'wt_iew_found_action', 'value'=>'skip')
                    )
                ),
                array(
                    'help_text'=> __('This option will update the existing coupons as per the data from the input file.', 'order-import-export-for-woocommerce'),
                    'condition'=>array(
                        array('field'=>'wt_iew_found_action', 'value'=>'update')
                    )
                )
            ),
            'form_toggler'=>array(
                'type'=>'parent',
                'target'=>'wt_iew_found_action'
            )
        );       
        
        
        foreach ($fields as $fieldk => $fieldv) {
            $out[$fieldk] = $fieldv;
        }
        return $out;
    }

    /**
     *  Customize the items in filter export page
     */
    public function exporter_alter_filter_fields($fields, $base, $filter_form_data) {

        if ($base == $this->module_base)
        {
            /* altering help text of default fields */
            $fields['limit']['label']=__('Total number of coupons to export', 'order-import-export-for-woocommerce'); 
            $fields['limit']['help_text']=__('Provide the number of coupons you want to export. e.g. Entering 500 with a skip count of 10 will export coupons from 11th to 510th position.', 'order-import-export-for-woocommerce');
            $fields['offset']['label']=__('Skip first <i>n</i> coupons', 'order-import-export-for-woocommerce');
            $fields['offset']['help_text']=__('Skips specified number of coupons from the beginning of the database. e.g. Enter 10 to skip first 10 coupons from export.', 'order-import-export-for-woocommerce');

            $fields['statuses'] = array(
                'label' => __('Coupon status', 'order-import-export-for-woocommerce'),
                'placeholder' => __('Any status', 'order-import-export-for-woocommerce'),
                'field_name' => 'statuses',
                'sele_vals' => self::get_coupon_statuses(),
                'help_text' => __('Filter coupons on the basis of status. Multiple statuses can be selected.', 'order-import-export-for-woocommerce'),
                'type' => 'multi_select',
                'css_class' => 'wc-enhanced-select',
                'validation_rule' => array('type'=>'text_arr')
            );
            $fields['types'] = array(
                'label' => __('Coupon type', 'order-import-export-for-woocommerce'),
                'placeholder' => __('Any type', 'order-import-export-for-woocommerce'),
                'field_name' => 'types',
                'sele_vals' => self::get_coupon_types(),
                'help_text' => __('Filter coupons on the basis of type. Multiple types can be selected.', 'order-import-export-for-woocommerce'),
                'type' => 'multi_select',
                'css_class' => 'wc-enhanced-select',
                'validation_rule' => array('type'=>'text_arr')
            );

            
            $fields['coupon_amount_from'] = array(
                'label'=>__("Coupon amount: from", 'order-import-export-for-woocommerce'),
                'placeholder' => __('From amount', 'order-import-export-for-woocommerce'),
                'type'=>'number',
                'value' =>'',
                'attr' =>array(
                        'min'=>0,
                    ),
                'field_name'=>'coupon_amount_from',
                'help_text'=>__('Minimum Coupon amount : Exports coupons of amount equal to or greater than specified amount.', 'order-import-export-for-woocommerce'),
                'validation_rule'=>array('type'=>'floatval'),
            
            );
            
            
            $fields['coupon_amount_to'] = array(
                'label'=>__("Coupon amount: to", 'order-import-export-for-woocommerce'),
                'placeholder' => __('To amount', 'order-import-export-for-woocommerce'),
                'type'=>'number',
                'value' =>'',
                'attr' =>array(
                        'min'=>0,
                    ),
                'field_name'=>'coupon_amount_to',
                'help_text'=>__('Maximum Coupon amount: Exports coupons of amount up to the specified amount.', 'order-import-export-for-woocommerce'),
                'validation_rule'=>array('type'=>'floatval'),
            
            );
  
            
            
            $fields['coupon_exp_date_from'] = array(
                'label' => __('Coupon expiry date: from', 'order-import-export-for-woocommerce'),
                'placeholder' => __('From date', 'order-import-export-for-woocommerce'),
                'field_name' => 'coupon_exp_date_from',
                'sele_vals' => '',
                'help_text' => __('Exports coupons that will expire on or after the specified date.', 'order-import-export-for-woocommerce'),
                'type' => 'text',
                'css_class' => 'wt_iew_datepicker',                
            );
            
            $fields['coupon_exp_date_to'] = array(
                'label' => __('Coupon expiry date: to', 'order-import-export-for-woocommerce'),
                'placeholder' => __('To date', 'order-import-export-for-woocommerce'),
                'field_name' => 'coupon_exp_date_to',
                'sele_vals' => '',
                'help_text' => __('Exports coupons that will expire on the specified date.', 'order-import-export-for-woocommerce'),
                'type' => 'text',
                'css_class' => 'wt_iew_datepicker',                
            );

            $fields['sort_columns'] = array(
                'label' => __('Sort columns', 'order-import-export-for-woocommerce'),
                'placeholder' => __('ID', 'order-import-export-for-woocommerce'),
                'field_name' => 'sort_columns',
                'sele_vals' => self::get_coupon_sort_columns(),
                'help_text' => __('Select the columns on the basis of which you want to sort the exported data in the order specified.', 'order-import-export-for-woocommerce'),
                'type' => 'multi_select',
                'css_class' => 'wc-enhanced-select',
                'validation_rule' => array('type'=>'text_arr')
            );

            $fields['order_by'] = array(
                'label' => __('Sort by', 'order-import-export-for-woocommerce'),
                'placeholder' => __('ASC', 'order-import-export-for-woocommerce'),
                'field_name' => 'order_by',
                'sele_vals' => array('ASC' => __('Ascending', 'order-import-export-for-woocommerce'), 'DESC' => __('Descending', 'order-import-export-for-woocommerce')),
                'help_text' => __('Sort the exported data based on the above selected columns. Defaulted to ascending order.', 'order-import-export-for-woocommerce'),
                'type' => 'select',
            );
        }
        return $fields;
    }
    public function get_item_by_id($id) {
		$post = array();
        $post['edit_url'] = get_edit_post_link($id);
        $post['title'] = get_the_title($id);
        return $post; 
    }
	public static function get_item_link_by_id($id) {
		$post = array();
        $post['edit_url'] = get_edit_post_link($id);
        $post['title'] = get_the_title($id);
        return $post; 
    }
}
}
new Wt_Import_Export_For_Woo_Basic_Coupon();
