<?php
/**
 * Queries Report
 *
 * Ensures all of the reports have a uniform class with helper functions.
 *
 * @since 6.0.0
 *
 * @package MonsterInsights
 * @subpackage Reports
 * @author  Chris Christoff
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

final class MonsterInsights_Report_Queries extends MonsterInsights_Report {

	public $title;
	public $class = 'MonsterInsights_Report_Queries';
	public $name = 'queries';
	public $version = '1.0.0';
	public $level = 'plus';

	/**
	 * Primary class constructor.
	 *
	 * @access public
	 * @since 6.0.0
	 */
	public function __construct() {
		$this->title = __( 'Search Console', 'ga-premium' );
		parent::__construct();
	}


	/**
	 * Prepare report-specific data for output.
	 *
	 * @param array $data The data from the report before it gets sent to the frontend.
	 *
	 * @return mixed
	 */
	public function prepare_report_data( $data ) {
		$auth = MonsterInsights()->auth;

		// Add GA links.
		if ( ! empty( $data['data'] ) && $auth->get_connected_type() !== 'v4' ) {
			$data['data']['galinks'] = array(
				'queries' => 'https://analytics.google.com/analytics/web/#report/acquisition-sc-queries/' . MonsterInsights()->auth->get_referral_url() . $this->get_ga_report_range( $data['data'] ),
			);
		}

		return $data;
	}

}
